package ru.yandex.travel.yt_lucene_index.utils

import com.google.protobuf.GeneratedMessageV3
import com.google.protobuf.InvalidProtocolBufferException
import com.google.protobuf.Parser
import org.apache.lucene.document.Document
import java.lang.RuntimeException

object DocumentUtils {
    fun <T : GeneratedMessageV3> Document.getProtoField(parser: Parser<T>, fieldName: String): T {
        return try {
            parser.parseFrom(getField(fieldName).binaryValue().bytes)
        } catch (e: InvalidProtocolBufferException) {
            throw RuntimeException(e)
        }
    }

    fun Document.getIntField(fieldName: String): Int {
        return getField(fieldName).numericValue().toInt()
    }
}
