package ru.yandex.travel.yt.util;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.CypressNodeType;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yt.ytclient.proxy.request.CreateNode;

@Slf4j
public class YtHelper {

    private YtHelper() {
    }

    public static YPath createTable(
            Yt yt,
            GUID transactionId,
            boolean pingAncestorTransaction,
            String tablePath,
            YTreeNode tableSchema
    ) {
        YPath table = YPath.simple(tablePath);
        return createTable(yt, transactionId, pingAncestorTransaction, table, tableSchema);
    }

    public static YPath createTable(
            Yt yt,
            GUID transactionId,
            boolean pingAncestorTransaction,
            YPath table,
            YTreeNode tableSchema
    ) {
        if (yt.cypress().exists(table)) {
            yt.cypress().remove(Optional.of(transactionId), pingAncestorTransaction, table);
        }
        yt.cypress().create(
                new CreateNode(table, CypressNodeType.TABLE)
                        .setAttributes(Map.of("schema", tableSchema))
                        .setRecursive(true)
                        .setIgnoreExisting(false)
                        .setTransactionalOptionsOfTransactionId(transactionId));
        return table;
    }

    public static void doInTx(Yt yt, Duration transactionDuration, Consumer<GUID> action) {
        GUID txId = yt.transactions().start(transactionDuration);
        try {
            log.info("Running yt operation in the [{}] transaction", txId);
            action.accept(txId);
            yt.transactions().commit(txId);
        } catch (Exception e) {
            try {
                log.warn("Aborting transaction [{}] due to exception {}", txId, e);
                yt.transactions().abort(txId);
            } catch (Exception e2) {
                log.warn("Failed to abort transaction [{}]", txId, e2);
                e.addSuppressed(e2);
            }
            throw e;
        }
    }
}
