package ru.yandex.travel.yt.util;

import NYT.Extension;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;

import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class YtProtoUtils {

    public static YTreeNode getTableSchemaForMessage(Message message) {
        YTreeBuilder treeBuilder = YTree.listBuilder();
        message.getDescriptorForType().getFields().forEach(fieldDescriptor ->
                treeBuilder.value(ytColumnDef(
                        getColumnName(fieldDescriptor),
                        mapType(fieldDescriptor),
                        fieldDescriptor.isRequired())));
        return treeBuilder.buildList();
    }

    private static String mapType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.isRepeated()) {
            return "any";
        }
        switch (fieldDescriptor.getType()) {
            case DOUBLE:
            case FLOAT:
                return "double";
            case SINT32:
            case SFIXED32:
            case INT32:
                return "int32";
            case SINT64:
            case SFIXED64:
            case INT64:
                return "int64";
            case FIXED32:
            case UINT32:
                return "uint32";
            case FIXED64:
            case UINT64:
                return "uint64";
            case BOOL:
                return "boolean";
            case STRING:
            case ENUM:
            case BYTES:
                return "string";
            case GROUP:
            case MESSAGE:
                return "any";
            default:
                throw new RuntimeException("Unrecognized type: " + fieldDescriptor.getJavaType());
        }
    }

    private static String getColumnName(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getOptions().hasExtension(Extension.keyColumnName)) {
            return fieldDescriptor.getOptions().getExtension(Extension.keyColumnName);
        } else if (fieldDescriptor.getOptions().hasExtension(Extension.columnName)) {
            return fieldDescriptor.getOptions().getExtension(Extension.columnName);
        }
        return fieldDescriptor.getName();
    }

    private static YTreeNode ytColumnDef(String name, String type, boolean required) {
        return YTree.mapBuilder()
                .key("name").value(name)
                .key("type").value(type)
                .key("required").value(required)
                .buildMap();
    }
}
