import json
import logging

from travel.library.python.aioapp.utils import request_var


class DeployJsonFormatter(logging.Formatter):
    @staticmethod
    def get_context():
        try:
            return request_var.get()
        except LookupError:
            return {}

    def format(self, record):
        log_data = {
            'message': record.getMessage(),
            'level': record.levelno,
            'levelStr': record.levelname,
        }

        if record.exc_info:
            exc = logging.Formatter.formatException(self, record.exc_info)
            log_data['stackTrace'] = exc

        fields = {}

        log_context_fields = self.get_context()
        if log_context_fields:
            fields['context'] = log_context_fields

        if fields:
            log_data['@fields'] = fields

        return json.dumps(log_data, ensure_ascii=False)
