from aiohttp import web
from marshmallow import ValidationError

from travel.library.python.aioapp.utils import request_var


def error_middleware_with_log(log):
    async def log_error(request, msg):
        data = await request.text()
        log.exception('%s %s: %s/%s with data: %s', msg, request.method, request.path, request.query_string, data)

    @web.middleware
    async def error_middleware(request, handler):
        try:
            return await handler(request)
        except ValidationError as ex:
            await log_error(request, 'Bad request')
            return web.json_response({'error': repr(ex)}, status=400)
        except Exception as ex:
            await log_error(request, 'Internal error')
            return web.json_response({'error': repr(ex)}, status=500)
    return error_middleware


@web.middleware
async def context_middleware(request, handler):
    request_data = {}

    request_id = request.headers.get('X-Request-Id')
    if request_id:
        request_data['request_id'] = request_id

    trace_id = request.headers.get('X-Trace-Id')
    if trace_id:
        request_data['trace_id'] = trace_id

    request_var.set(request_data)
    return await handler(request)
