import contextvars
from datetime import datetime

import pytz


request_var = contextvars.ContextVar('request_var')


def localize_dt(dt, timezone, datetime_pattern='%Y-%m-%dT%H:%M'):
    if isinstance(timezone, str):
        timezone = pytz.timezone(timezone)
    return timezone.localize(datetime.strptime(dt, datetime_pattern))
