
import os
import logging

ARCADIA_ROOT_ENV = 'ARCADIA_ROOT'
ARCADIA_ROOT_FILE = ".arcadia.root"


def find_arcadia_root(allow_missing=False):
    path = os.getenv(ARCADIA_ROOT_ENV)
    if path:
        logging.debug(f'Arcadia root got from ${ARCADIA_ROOT_ENV}: {path}')
        if not os.path.exists(path):
            raise Exception(f'${ARCADIA_ROOT_ENV} refers inexistent directory {path}')
        return path
    path = os.getcwd()
    while True:
        if os.path.exists(os.path.join(path, ARCADIA_ROOT_FILE)):
            logging.debug(f'Arcadia root found by {ARCADIA_ROOT_FILE} file: {path}')
            return path
        parent = os.path.dirname(path)
        if parent == path:
            if allow_missing:
                logging.warning('Arcadia root not found')
                return None
            else:
                raise Exception("Failed to find Arcadia root")
        path = parent


def get_arcadia_path(*parts):
    arcadia_path = find_arcadia_root()
    return os.path.join(arcadia_path, *parts)
