# BaseHttpClient

Это базовый py2/py3 HTTP-клиент, который умеет:
- настраивать таймауты
- настраивать ретраи
- настраивать CircuitBreaker
- включать/отключать трассировку в jaeger
- добавлять хедеры:
  - обычные словари
  - генерируемые при вызове метода (например: TVM)
- логировать запросы и маскировать параметры

## Уровни настроек
Все настройки доступны на 3-ёх уровнях (имеют одно название с точностью до регистра):
1) клиент (код класса-наследника)
```python
class MyClient(BaseHttpClient):
    RETRY_CONFIG = RetryConfig(total=1)
```
2) инстанс (конструктор)
```python
my_client_instance = MyClient(..., retry_config=RetryConfig(total=2))
```
3) метод
```python
my_client_instance.call_some_handler(..., retry_config=RetryConfig(total=3))
```

Каждый новый уровень может переопреелять настройки предыдущего. Примеры:
- настроить один конфиг ретраев на весь клиент, но у отдельной ручки его изменить/убрать
- настроить на клиенте дефолтный Circuit Breaker, но выключить его для инстанса колдунщика

Логика переопределения настроек разруливается через [скоупы](./scope_configurator.py).

## Настройки
### Таймаут
Настраивается через:
- `timeout` - время таймаута в секундах.
- `disable_timeout` - должно быть явным образом выставлено в `True`, чтобы в текущем скоупе отключить таймаут.

### [RetryConfig](./retry_config.py)
Параметры такие же, как и у [Retry из urllib](https://urllib3.readthedocs.io/en/latest/reference/urllib3.util.html#urllib3.util.Retry). Не разрешается создавать пустую конфигурацию.

Доступные методы:
- `evolve` - позволяет скопировать настройки конфига, из которого он вызван, и добавить/переопределить только те аргументы, которые переданы на вход этой ф-ии. Возвращает новый RetryConfig.
- `set_excluded_status_codes` - необходим для удобной установки статус-кодов, для которых НЕ НУЖНО ретраить запросы. "Инвертирует" список переданных статус-кодов и сохраняет в `status_forcelist`, который является списком статус-кодов, которые НУЖНО ретраеить.

**Важно!** Ретраи по дефолту не работают на POST-запросы. Для включения необходимо в аргументы прописать `method_whitelist={'POST'}`. [Пример](https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/library/python/api_clients/travel_api/client.py?rev=r8535367#L70)

Настраивается через:
- `retry_config` - конфигурация RetryConfig. Настройка должна быть на уровне скоупа инстанса, если ретраи не отключены явным образом.
- `disable_retry_config` - должно быть явным образом выставлено в `True`, чтобы в текущем скоупе отключить ретраи.

### [CircuitBreakerConfig](./circuit_breaker_config.py)
Параметры такие же, как у [pybreaker](https://github.com/danielfm/pybreaker). Не разрешается создавать пустую конфигурацию.

Доступные методы:
- `evolve` - аналогично RetryConfig
- `set_excluded_status_codes` - список статус-кодов, на которые НЕ НУЖНО реагировать CircuitBreaker. Складывает в поле `exclude`.

Настраивается через:
- `circuit_breaker_config` - конфигурация CircuitBreakerConfig. Настройка должна быть на уровне скоупа инстанса, если CircuitBreaker не отключен явным образом.
- `disable_circuit_breaker_config` - должен быть явным образом выставлен в `True`, чтобы в текущем скоупе отключить CircuitBreaker.

### Трейсинг
Оборачивает методы в `traced_function` из `travel.library.python.tracing.instrumentation`.

**Важно!** Сама конфигурация jaeger должна быть на уровне сервиса, используещего HTTP-клиент.

Настраивается через:
- `disable_tracing` - должно быть явным образом выставлено в `True`, чтобы в текущем скоупе отключить трассировку.

### Кастомные заголовки
Настраиваются через:
- `headers` - словарик хедеров, которые будут добавлены в запрос.
- `custom_headers_creators` - классы, реализующие интерфейс [CustomHeadersCreator](custom_headers_creator.py). При каждом запросе будет вызван метод `get_headers`, который вернёт словарь с необходимыми хедерами.
Сейчас используется для получения [tvm-тикетов](https://a.yandex-team.ru/arc_vcs/travel/rasp/library/python/common/data_api/tvm/header_creator.py) и [других видов авторизации](./auth.py).

### Логгер
Каждый запрос автоматически логируется с хедером `[{http_client_name} ({method} {url} with params {params})]`.
Кроме того добавляет в [контекст записи лога](./client_logger_context.py) имя клиента и `http_client_request_id` - уникальный идентификатор для каждого запроса. В qloud и deploy по этим параметрам удобно смотреть на запросы от одного клиента и/или конкретные запросы.

Настраивается через:
- `masked_params` - позволяет задать список аргументов, которые будут заменены на `MASK_FOR_PARAMS_LOGGING`.
- `MASK_FOR_PARAMS_LOGGING` (только на уровне клиента) - строка, которая будет заменять замаскированные параметры.
- `HTTP_CLIENT_NAME` (только на уровне клиента) - имя клиента, которое попадёт в заголовок записи и в контекст. Если параметр не выставлен, то будет использоваться питонячье имя класса клиента.

## Методы
Основной метод - `make_request`.
- Принимает необходимые параметры запроса и конфигурации (тот самый 3-ий уровень).
- Создаёт сессию с параметрами скоупа и пытается сделать запрос.
- Возвращает `requests.Response`, либо падает с ошибкой (все ошибки прокидываются дальше "как есть").

Для удобства созданы методы `get, post, put`.

## Примеры использования:
Все текущие примеры лежат в [api_clients расписаний](https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/library/python/api_clients).
