# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from base64 import b64encode
from typing import AnyStr, Dict

from travel.library.python.base_http_client.custom_headers_creator import CustomHeadersCreator


class OAuthHeaderCreator(CustomHeadersCreator):
    def __init__(self, auth_token):
        self.auth_token = auth_token

    def get_headers(self):
        # type: () -> Dict[AnyStr, AnyStr]
        return {'Authorization': 'OAuth {}'.format(self.auth_token)} if self.auth_token else {}


class HTTPBasicAuthHeaderCreator(CustomHeadersCreator):
    def __init__(self, username, password):
        # type: (AnyStr, AnyStr) -> ()
        self.username = username
        self.password = password

    def get_headers(self):
        # type: () -> Dict[AnyStr, AnyStr]
        # Код продублирован из стандартной реализации параметра auth библиотеки requests
        # https://github.com/psf/requests/blob/33cf965f7271ab4978ed551754db37865c4085db/requests/auth.py#L60

        username = self.username.encode('latin1')
        password = self.password.encode('latin1')

        b64_str = b64encode(b':'.join((username, password))).strip()
        decoded_str = b64_str.decode('ascii')

        return {'Authorization': 'Basic {}'.format(decoded_str)}
