# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from contextlib import contextmanager
from uuid import uuid4

from ylog.context import log_context


@contextmanager
def client_logger_context(http_client_name, **kwargs):
    request_id = uuid4().hex
    context_data = {'http_client_name': http_client_name, 'http_client_request_id': request_id}
    context_data.update(kwargs)
    with log_context(**context_data):
        yield
