# -*- coding: utf-8 -*-
import os


def default_config(log_path):
    conf = {
        'version': 1,
        'disable_existing_loggers': False,
        'root': {
            'handlers': ['tree', 'error', 'traceback', 'cloud'],
            'level': 'INFO',
        },
        'formatters': {
            'verbose': {
                'format': '%(levelname)s %(asctime)s: (%(name)s) %(message)s',
                'datefmt': '%Y-%m-%d %H:%M:%S'
            },
            'tree': {
                'format': '%(levelname)s %(asctime)s: %(message)s',
                'datefmt': '%Y-%m-%d %H:%M:%S'
            },
            'error': {
                '()': 'ylog.ExceptionFormatter',
                'format': '%(asctime)s %(name)-15s %(levelname)-10s %(message)s'
            },
            'traceback': {
                '()': 'ylog.ExceptionFormatter',
                'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
                'full': True,
                'show_locals': True
            },
        },
        'handlers': {
            'cloud': {
                'level': 'INFO',
                'class': 'logging.StreamHandler',
                'formatter': 'verbose',
            }
        },
    }

    if log_path:
        conf['handlers'].update({
            'tree': {
                'level': 'INFO',
                'class': 'cloud_logger.handlers.FileTreeHandler',
                'base_path': log_path,
                'formatter': 'tree'
            },
            'error': {
                'class': 'logging.handlers.WatchedFileHandler',
                'filename': os.path.join(log_path, 'error.log'),
                'formatter': 'error',
                'level': 'ERROR',
            },
            'traceback': {
                'class': 'logging.handlers.WatchedFileHandler',
                'filename': os.path.join(log_path, 'traceback.log'),
                'formatter': 'traceback',
                'level': 'ERROR',
            }
        })

    if os.getenv('QLOUD_COMPONENT') is not None:
        conf['formatters']['json'] = {
            '()': 'cloud_logger.formatters.QloudJsonFormatter',
            'format': '%(name)s: %(levelname)s %(asctime)s %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
        }
        conf['handlers']['cloud']['formatter'] = 'json'

    if os.getenv('DEPLOY_STAGE_ID') is not None:
        conf['formatters']['json'] = {
            '()': 'cloud_logger.formatters.DeployJsonFormatter',
            'format': '%(name)s: %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
        }
        conf['handlers']['cloud']['formatter'] = 'json'

    return conf
