# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

import ujson


class QloudJsonFormatter(logging.Formatter):
    """Формат сообщений в лог для qloud в формате json"""

    def format(self, record):
        """
        :param logging.LogRecord record:
        :return: str
        """
        data = {
            'message': self._format_message(record),
            'level': record.levelname,
        }

        fields = {
            'file': {
                'path': record.pathname,
                'line': record.lineno,
                'func': record.funcName,
            },
            'loggerName': record.name,
            'module': record.module,
            'process': record.process,
            'processName': record.processName,
            'thread': record.thread,
            'threadName': record.threadName,
        }

        if record.exc_info:
            data['stackTrace'] = self.formatException(record.exc_info)

        data['@fields'] = fields

        return ujson.dumps(data)

    def _format_message(self, record):
        """
        :param logging.LogRecord record:
        :return: str
        """

        if self.usesTime():
            record.asctime = self.formatTime(record, self.datefmt)

        params = {
            'message': record.getMessage(),
        }
        params.update(record.__dict__)

        return self._fmt % params


class DeployJsonFormatter(logging.Formatter):
    """Формат сообщений в лог для Y.Deploy в формате json"""

    def format(self, record):
        """
        :param logging.LogRecord record:
        :return: str
        """
        data = {
            'message': self._format_message(record),
            'level': record.levelno,
            'levelStr': record.levelname,
            'loggerName': record.name,
            'threadName': record.threadName,
        }
        if record.exc_info:
            data['stackTrace'] = self.formatException(record.exc_info)

        fields = {
            'file': {
                'path': record.pathname,
                'line': record.lineno,
                'func': record.funcName,
            },
            'module': record.module,
            'process': record.process,
            'processName': record.processName,
            'thread': record.thread,
        }

        data['@fields'] = fields

        return ujson.dumps(data)

    def _format_message(self, record):
        """
        :param logging.LogRecord record:
        :return: str
        """

        if self.usesTime():
            record.asctime = self.formatTime(record, self.datefmt)

        params = {
            'message': record.getMessage(),
        }
        params.update(record.__dict__)

        return self._fmt % params
