import os
from setuptools import find_packages, setup

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

requires = [
    'ujson',
    'ylog',
]

setup(
    name='avia-qloud-logger',
    version='1.0.3',
    packages=find_packages(),
    include_package_data=True,
    license='BSD License',
    description='Qloud logger',
    long_description=README,
    author='Avia team',
    author_email='avia-dev@yandex-team.ru',
    classifiers=[
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
    ],
    install_requires=requires,
)
