# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
import sys
import tempfile
from contextlib import closing

from six.moves import urllib


# Contains /Applications/PyCharm.app/Contents/debug-eggs/pycharm-debug.egg
PYCHARM_DEBUG_EGG_URL = 'https://proxy.sandbox.yandex-team.ru/634102140'


def download_pydevd_egg(egg_directory='/tmp', egg_url=PYCHARM_DEBUG_EGG_URL):
    egg_path = os.path.join(egg_directory, 'pycharm-debug.egg')
    print('Downloading {} to {}'.format(egg_url, egg_path))
    if not os.path.exists(egg_path):
        with tempfile.NamedTemporaryFile(prefix='pycharm-debug.egg.', dir=egg_directory) as tmp_file, closing(urllib.request.urlopen(egg_url)) as source:
            while True:
                chunk = source.read(65536)
                if not chunk:
                    break
                tmp_file.write(chunk)
            os.chmod(tmp_file.name, 0o644)
            os.rename(tmp_file.name, egg_path)
            tmp_file.delete = False
    print('Downloading {} to {} -> done'.format(egg_url, egg_path))

    return egg_path


def install_pydevd():
    print('Installing pydevd')

    egg_path = download_pydevd_egg()
    if egg_path not in sys.path:
        sys.path.append(egg_path)

    print('Installing pydevd -> done')
