from collections import namedtuple

from travel.proto.dicts.avia.near_direction_pb2 import TNearDirection

from travel.library.python.dicts.base_repository import BaseRepository

Distances = namedtuple('Distances', ('min', 'default', 'max'))


class NearDirectionRepository(BaseRepository):
    _PB = TNearDirection

    def __init__(self):
        super(NearDirectionRepository, self).__init__()
        self._distances_by_direction = {}

    def _fill_distances(self):
        for d in self.itervalues():
            self._distances_by_direction[(d.DepartureSettlementId, d.ArrivalSettlementId)] = Distances(
                d.MinDistance,
                d.DefaultDistance,
                d.MaxDistance,
            )

    def load_from_file(self, path):
        super(NearDirectionRepository, self).load_from_file(path)
        self._fill_distances()

    def load_from_string(self, content):
        super(NearDirectionRepository, self).load_from_string(content)
        self._fill_distances()

    def get_default_distance(self, departure_settlement_id, arrival_settlement_id, default=None):
        direction = (departure_settlement_id, arrival_settlement_id)
        if direction in self._distances_by_direction:
            return self._distances_by_direction[direction].default
        return default
