# coding: utf-8
from __future__ import unicode_literals, absolute_import, print_function, division

import factory

from travel.proto.commons_pb2 import TTranslation

from travel.proto.dicts.rasp.aviaalliance_pb2 import TAviaAlliance


class TAviaAllianceTitleFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'RussianTitle'
    En = 'EnglishTitle'
    Tr = 'TurkishTitle'
    Uk = 'UkrainianTitle'


class TAviaAllianceDescriptionFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'RussianDescription'
    En = 'EnglishDescription'
    Tr = 'TurkishDescription'
    Uk = 'UkrainianDescription'


class TAviaAllianceFactory(factory.Factory):
    class Meta:
        model = TAviaAlliance

    Id = factory.Sequence(lambda n: 10000 + n)
    LogoSvg = 'logo.svg'
    Enabled = 0
    TitleDefault = 'AllianceName'
    Title = factory.SubFactory(TAviaAllianceTitleFactory)
    DescriptionDefault = 'AllianceDescription'
    Description = factory.SubFactory(TAviaAllianceDescriptionFactory)
