# coding: utf-8
from __future__ import unicode_literals, absolute_import, print_function, division

import factory

from travel.proto.dicts.rasp.carrier_pb2 import TCarrier


class TCarrierFactory(factory.Factory):
    class Meta:
        model = TCarrier

    Id = factory.Sequence(lambda n: 500000 + n)
    Address = 'Address'
    HomeStationId = 0

    SirenaId = factory.Sequence(lambda n: 'sirena_{}'.format(n))
    Iata = factory.Sequence(lambda n: 'IATA_{}'.format(n))
    Icao = factory.Sequence(lambda n: 'ICAO_{}'.format(n))
    IcaoRu = factory.Sequence(lambda n: 'ICAO_RU_{}'.format(n))
    TisCode = factory.Sequence(lambda n: 'TIS_{}'.format(n))
    ExpressCode = factory.Sequence(lambda n: 'Express_{}'.format(n))
    YandexAviaCode = factory.Sequence(lambda n: 'YA_{}'.format(n))

    Title = 'Title'
    TitleEn = 'Title En'
    Url = 'http://example.com'
    ContactInfo = 'Contact info'
    Description = 'Description'
    Logo = ''

    CountryId = 0
    TransportType = 2
    IsHidden = False
    IsStrange = False
    Email = 'my-company@example.com'
    Phone = '+7 555 555 55 55'
    PhoneBooking = '+7 555 555 55 66'
    MetaTitle = 'Meta title'
    MetaDescription = 'Meta description'
    SupplierCode = factory.Sequence(lambda n: 'supplier-code-{}'.format(n))
    TitleRu = 'Title Ru'
    TitleUk = 'Title Uk'
    TitleTr = 'Title Tr'
    ShortTitle = 'Short title'
    ShortTitleRu = 'Short title ru'
    ShortTitleEn = 'Short title en'
    ShortTitleUk = 'Short title uk'
    ShortTitleTr = 'Short title tr'
    IsFreight = False
    Icon = ''
    LogoMono = ''
    LogoBgColor = ''
    Priority = 10
    SvgLogo = ''
    AllianceId = 0
    BonusName = 'Bonus'
    BonusNameRu = 'Bonus ru'
    BonusNameEn = 'Bonus en'
    BonusNameTr = 'Bonus tr'
    BonusNameUk = 'Bonus uk'
    Svg2PngLogo = ''
    RegistrationPhone = '+7 555 555 55 77'
    RegistrationPhoneRu = '+7 555 555 55 78'
    RegistrationPhoneEn = '+7 555 555 55 79'
    RegistrationPhoneTr = '+7 555 555 55 70'
    RegistrationPhoneUk = '+7 555 555 55 71'
    RegistrationUrl = 'http://example.com/reg'
    RegistrationUrlRu = 'http://example.com/ru/reg'
    RegistrationUrlEn = 'http://example.com/en/reg'
    RegistrationUrlTr = 'http://example.com/tr/reg'
    RegistrationUrlUk = 'http://example.com/uk/reg'
