# coding: utf-8
from __future__ import unicode_literals, absolute_import, print_function, division

import factory

from travel.proto.commons_pb2 import (
    TTranslationCase, TTranslationCaseRu, TTranslationCaseEn, TTranslationCaseUk, TTranslationCaseTr
)
from travel.proto.dicts.rasp.country_pb2 import TCountry


class TCountryTitleRuFactory(factory.Factory):
    class Meta:
        model = TTranslationCaseRu

    Nominative = 'Страна'
    Prepositional = 'Стране'
    LocativePreposition = 'в'
    Genitive = 'Страны'


class TCountryTitleEnFactory(factory.Factory):
    class Meta:
        model = TTranslationCaseEn

    Nominative = 'Country'


class TCountryTitleUkFactory(factory.Factory):
    class Meta:
        model = TTranslationCaseUk

    Nominative = 'Країна'
    Accusative = 'Країну'


class TCountryTitleTrFactory(factory.Factory):
    class Meta:
        model = TTranslationCaseTr

    Nominative = 'Ülke'


class TCountryTitleFactory(factory.Factory):
    class Meta:
        model = TTranslationCase

    Ru = factory.SubFactory(TCountryTitleRuFactory)
    En = factory.SubFactory(TCountryTitleEnFactory)
    Uk = factory.SubFactory(TCountryTitleUkFactory)
    Tr = factory.SubFactory(TCountryTitleTrFactory)


class TCountryFactory(factory.Factory):
    class Meta:
        model = TCountry

    Id = factory.Sequence(lambda n: 100000 + n)
    GeoId = factory.Sequence(lambda n: 100000 + n)
    Code = 'ZZ'
    TitleDefault = 'Страна'
    Title = factory.SubFactory(TCountryTitleFactory)
    KladrId = 'kladr'
    Code3 = 'ZZZ'
    DomainZone = 'zz'
    CurrencyId = 0
    Language = 'ru'
