# coding: utf-8
from __future__ import unicode_literals, absolute_import, print_function, division

import factory

from travel.proto.commons_pb2 import TTranslation
from travel.proto.dicts.rasp.currency_pb2 import TCurrency


class TCurrencyTitleFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'рубли'
    Tr = 'Ruble'
    Uk = 'рублі'


class TCurrencyTitleInFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'в рублях'
    Uk = 'у рублях'


class TCurrencyTemplateFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'template'
    Tr = 'template tr'


class TCurrencyTemplateWholeFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'template whole'
    Tr = 'template whole tr'


class TCurrencyTemplateCentsFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'template cents'
    Tr = 'template cents tr'


class TCurrencyFactory(factory.Factory):
    class Meta:
        model = TCurrency

    Id = factory.Sequence(lambda n: 1 + n)
    Code = 'ZZZ'
    IsoCode = 'ZZZ'
    Order = 100
    OrderTr = 100
    OrderUa = 100
    Title = factory.SubFactory(TCurrencyTitleFactory)
    TitleIn = factory.SubFactory(TCurrencyTitleInFactory)
    Template = factory.SubFactory(TCurrencyTemplateFactory)
    TemplateWhole = factory.SubFactory(TCurrencyTemplateWholeFactory)
    TemplateCents = factory.SubFactory(TCurrencyTemplateCentsFactory)
