# coding: utf-8
from __future__ import unicode_literals, absolute_import, print_function, division

import factory

from travel.proto.commons_pb2 import TTranslation
from travel.proto.dicts.rasp.region_pb2 import TRegion


class RegionTitleNominativeFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'Область'
    Uk = 'Область'
    En = 'Region'
    Tr = 'Bölge'


class TRegionFactory(factory.Factory):
    class Meta:
        model = TRegion

    Id = factory.Sequence(lambda n: 300000 + n)
    GeoId = factory.Sequence(lambda n: 300000 + n)
    AgentGeoId = factory.Sequence(lambda n: 300000 + n)

    TitleDefault = 'Область'
    TitleNominative = factory.SubFactory(RegionTitleNominativeFactory)
    TitleRuNominativeCase = '[Deprecated] Область'
    TitleUkNominativeCase = '[Deprecated] Область'

    CountryId = 225
    TimeZoneId = 42

    IsDisputedTerritory = False
    IsHidden = False

    KladrId = factory.Sequence(lambda n: 'kladr_{}'.format(n))
    Koatuu = factory.Sequence(lambda n: 'koatuu_{}'.format(n))
