# coding: utf-8
from __future__ import unicode_literals, absolute_import, print_function, division

import factory

from travel.proto.commons_pb2 import (
    TTranslation, TTranslationCase, TTranslationCaseRu, TTranslationCaseEn, TTranslationCaseUk, TTranslationCaseTr
)
from travel.proto.dicts.rasp.settlement_pb2 import TSettlement


class SettlementAbbrTitleFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'Г'
    Uk = 'М'
    En = 'T'
    Tr = 'K'


class TSettlementTitleRuFactory(factory.Factory):
    class Meta:
        model = TTranslationCaseRu

    Nominative = 'Город'
    Prepositional = 'Городе'
    LocativePreposition = 'в'
    Genitive = 'Города'
    Accusative = 'Город'


class TSettlementTitleEnFactory(factory.Factory):
    class Meta:
        model = TTranslationCaseEn

    Nominative = 'Settlement'


class TSettlementTitleUkFactory(factory.Factory):
    class Meta:
        model = TTranslationCaseUk

    Nominative = 'Місто'


class TSettlementTitleTrFactory(factory.Factory):
    class Meta:
        model = TTranslationCaseTr

    Nominative = 'Kasaba'


class TSettlementTitleFactory(factory.Factory):
    class Meta:
        model = TTranslationCase

    Ru = factory.SubFactory(TSettlementTitleRuFactory)
    En = factory.SubFactory(TSettlementTitleEnFactory)
    Uk = factory.SubFactory(TSettlementTitleUkFactory)
    Tr = factory.SubFactory(TSettlementTitleTrFactory)


class TSettlementFactory(factory.Factory):
    class Meta:
        model = TSettlement

    Id = factory.Sequence(lambda n: 500000 + n)
    GeoId = factory.Sequence(lambda n: 500000 + n)
    AgentGeoId = factory.Sequence(lambda n: 500000 + n)

    TitleDefault = 'Город [default]'

    CountryId = 225
    TimeZoneId = 42

    RegionId = 0
    DistrictId = 0

    IsDisputedTerritory = False
    IsHidden = False

    KladrId = factory.Sequence(lambda n: 'kladr_{}'.format(n))
    Koatuu = factory.Sequence(lambda n: 'koatuu_{}'.format(n))

    TitleRuNominativeCase = '[deprecated] Город'
    TitleRuPreposition = '[deprecated] в'
    TitleRuPrepositionalCase = '[deprecated] Городе'
    TitleRuGenitiveCase = '[deprecated] Города'
    TitleRuAccusativeCase = '[deprecated] Город'
    TitleUkNominativeCase = '[deprecated] Місто'

    Majority = 3

    Longitude = 16
    Latitude = 17

    Slug = factory.Sequence(lambda n: 'slug_{}'.format(n))

    Title = factory.SubFactory(TSettlementTitleFactory)
    AbbrTitleDefault = 'Гd'
    AbbrTitle = factory.SubFactory(SettlementAbbrTitleFactory)

    PhoneInfo = 'phone_info'
    PhoneInfoShort = 'pi_shot'

    BigCity = True
    HasTablo = True
    HasManyAirports = False

    SuggestOrder = 100

    SirenaId = factory.Sequence(lambda n: 'sirena_{}'.format(n))
    Iata = factory.Sequence(lambda n: 'IATA_{}'.format(n))
