# coding: utf-8
from __future__ import unicode_literals, absolute_import, print_function, division

import factory

from travel.proto.commons_pb2 import TTranslation, TLocalizedFlags
from travel.proto.dicts.rasp.station_pb2 import TStation


class TStationTitleFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'Title Ru'
    Uk = 'Title Uk'
    En = 'Title En'
    Tr = 'Title Tr'


class TStationAddressFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'Address Ru'
    Uk = 'Address Uk'
    En = 'Address En'
    Tr = 'Address Tr'


class TStationTitleInFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'TitleIn Ru'
    Uk = 'TitleIn Uk'
    En = 'TitleIn En'
    Tr = 'TitleIn Tr'


class TStationTitleFromFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'TitleFrom Ru'
    Uk = 'TitleFrom Uk'
    En = 'TitleFrom En'
    Tr = 'TitleFrom Tr'


class TStationTitleToFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'TitleTo Ru'
    Uk = 'TitleTo Uk'
    En = 'TitleTo En'
    Tr = 'TitleTo Tr'


class TStationPopularTitleFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'Popular Title Ru'
    Uk = 'Popular Title Uk'
    En = 'Popular Title En'
    Tr = 'Popular Title Tr'


class TStationHowToGetToCityFactory(factory.Factory):
    class Meta:
        model = TTranslation

    Ru = 'HowToGetToCity Ru'
    Uk = 'HowToGetToCity Uk'
    En = 'HowToGetToCity En'
    Tr = 'HowToGetToCity Tr'


class TStationShouldOverrideTitleFactory(factory.Factory):
    class Meta:
        model = TLocalizedFlags

    Ru = False
    Uk = False
    En = False
    Tr = False


class TStationFactory(factory.Factory):
    class Meta:
        model = TStation

    Id = factory.Sequence(lambda n: 500000 + n)
    SettlementId = 213
    Majority = 1
    TimeZoneId = 42
    TimeZoneCode = 'Europe/Moscow'
    PopularTitleDefault = 'Popular Title Default'
    PopularTitleRuNominativeCase = '[deprecated] Popular Title Ru Nominative'
    PopularTitleRuGenitiveCase = '[deprecated] Popular Title Ru Genitive'
    PopularTitleUkNominativeCase = '[deprecated] Popular Title Uk Nominative'
    TitleDefault = 'Title Default'
    TitleRuNominativeCase = '[deprecated] Title Ru Nominative'
    TitleRuGenitiveCase = '[deprecated] Title Ru Genitive'
    TitleRuAccusativeCase = '[deprecated] Title Ru Accusative'
    TitleRuPrepositionalCase = '[deprecated] Title Ru Prepositional'
    TitleRuPreposition = 'в'
    TitleUkNominativeCase = '[deprecated] Title Uk Nominative'
    IsHidden = False
    Longitude = 20
    Latitude = 30
    Type = 9
    TransportType = 2
    RailwayTimeZoneId = 42
    RegionId = 0
    DistrictId = 0
    CountryId = 225
    NotGeneralize = True
    Title = factory.SubFactory(TStationTitleFactory)
    Address = factory.SubFactory(TStationAddressFactory)
    TitleIn = factory.SubFactory(TStationTitleInFactory)
    TitleFrom = factory.SubFactory(TStationTitleFromFactory)
    TitleTo = factory.SubFactory(TStationTitleToFactory)
    PopularTitle = factory.SubFactory(TStationPopularTitleFactory)
    HowToGetToCity = factory.SubFactory(TStationHowToGetToCityFactory)
    StationCodes = {}
    ShouldOverrideTitle = factory.SubFactory(TStationShouldOverrideTitleFactory)
    SiteUrl = 'http://example.com'
    UseDirection = 2
    SuburbanZoneId = 0
    HasAeroexpress = True
    NearMetro = 'near metro'
    MapZoom = 1
    TypeChoices = 'train,plane,bus'
    Photo = ''
    PanoramaUrl = ''
    ShowSettlement = True
    TabloState = ''
    SupplierId = 0
    FuzzyOnly = False
    VirtualEnd = False
    IncompleteBusSchedule = False
    ShowMode = ''
    IsFuzzy = False
    IsSearchableTo = True
    IsSearchableFrom = True
    InStationSchedule = True
    SchemaImage = ''
    TimeZoneNotCheck = False
    TabloStatePrev = ''
    InThread = True
    ShowTabloStat = True
    IsBase = True
    UseInDepartureForecast = True
    UseInForecast = True
    Slug = factory.Sequence(lambda n: 'slug_{}'.format(n))
    AgreedStopType = ''
    LocalAddress = ''
    LocalTitle = ''
    LocalPopularTitle = ''
    LocalHowToGetToCity = ''
