# -*- encoding: utf-8 -*-
import struct


def write_binary_string(output_file, binary_string, max_size=0):
    """ Writes binary string as (len(str), str) tuple with the bytes order that doesn't depend on OS """
    binary_form = bytearray(binary_string)
    proto_size = len(binary_form)
    if max_size > 0 and proto_size > max_size:
        raise Exception('Max proto size {} is exceeded ({})'.format(max_size, proto_size))
    output_file.write(struct.pack('<i', proto_size))
    output_file.write(binary_form)
    return proto_size
