from travel.proto.dicts.rasp.readable_timezone_pb2 import TReadableTimezone

from travel.library.python.dicts.base_repository import BaseRepository


class ReadableTimezoneRepository(BaseRepository):
    _PB = TReadableTimezone

    def __init__(self):
        super(ReadableTimezoneRepository, self).__init__(index_field='Key')

    def add_object(self, obj):
        key = getattr(obj, 'Language') + '/' + getattr(obj, self._index_field)

        self._storage[key] = obj
