# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import logging
import os
import sys


def manage():
    print('Loading manage.py')
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "local_settings")
    from django.core.management import execute_from_command_line
    execute_from_command_line(sys.argv)


def default_run(funcs_dict):
    """
    Используется в project/app.py, если он вызван без указания функции в Y_PYTHON_ENTRY_POINT.
    Например для дебага в Pycharm, когда бинарник запускается как голый интерпретатор Y_PYTHON_ENTRY_POINT=":main",
    с помощью PYTHON_ENTRYPOINT_RUN_FUNC в default_run можно выбрать нужную для дебага функцию.
    """
    func_name = os.getenv('PYTHON_ENTRYPOINT_RUN_FUNC')
    print('default_run', func_name)
    funcs_dict[func_name]()


def gunicorn_base(application):
    from library.python.gunicorn import run_standalone
    run_standalone(application)


def launch_base(jobs_config):
    from travel.library.python.entrypoint.launcher import Launcher

    launcher = Launcher(jobs_config)

    parser = argparse.ArgumentParser()
    jobs_desc = '\n'.join("{}: {}".format(key, conf['handler']) for key, conf in sorted(launcher.jobs.items()))
    parser.add_argument('job_key', type=str, metavar='JOB', help='Possible job keys are:\n{}'.format(jobs_desc))
    args = parser.parse_args()

    launcher.launch(args.job_key)


def scheduler_base(jobs_config, launch_entrypoint):
    from travel.library.python.entrypoint.launcher import Launcher
    from travel.library.python.entrypoint import scheduler

    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', action='store_true', default=True)
    args = parser.parse_args()

    if args.verbose:
        stdout_handler = logging.StreamHandler(sys.stdout)
        scheduler.log.addHandler(stdout_handler)
        scheduler.log.setLevel(logging.DEBUG)

        apscheduler_log = logging.getLogger('apscheduler')
        apscheduler_log.addHandler(stdout_handler)
        apscheduler_log.setLevel(logging.DEBUG)

    launcher = Launcher(jobs_config)
    scheduler = scheduler.Scheduler(launch_entrypoint, with_web_server=True)
    scheduler.add_jobs(launcher.jobs)
    scheduler.run()
