# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

log = logging.getLogger(__name__)


class TasksLaunchError(Exception):
    pass


class Launcher(object):
    def __init__(self, jobs_config):
        self.jobs = {}

        for conf in jobs_config:
            key, handler = conf[:2]

            try:
                options = conf[2]
            except IndexError:
                options = {}

            self.jobs[key] = {
                'handler': handler,
                'options': options,
            }

    def launch(self, job_key):
        job_conf = self.jobs.get(job_key)
        if job_conf is None:
            raise TasksLaunchError('Job key {} not found'.format(job_key))

        log.debug('Launching job: %s', job_key)
        args = job_conf['options'].get('args', ())
        kwargs = job_conf['options'].get('kwargs', {})
        return job_conf['handler'](*args, **kwargs)
