from travel.library.python.gunicorn.worker_watcher import WorkersWatcher
from travel.library.python.solomon.server import SolomonMetricsServer

# Config example for ThreadWorker
worker_class = 'travel.library.python.gunicorn.worker_watcher.workers.ThreadWorker'
workers = 2
threads = 4

# Config example for SyncWorker
# worker_class = 'travel.library.python.gunicorn.worker_watcher.workers.SyncWorker'
# workers = 3

watcher = WorkersWatcher()
solomon = SolomonMetricsServer()


def on_starting(server):
    watcher.on_starting(server)

    solomon.register_gauge({'sensor': 'requests_in_work'}, watcher.get_requests_in_work_count)
    solomon.register_gauge({'sensor': 'requests_in_work_max'}, watcher.get_max_requests_in_work)
    solomon.run_in_thread()


def pre_fork(arbiter, worker):
    watcher.pre_fork(arbiter, worker)


def child_exit(server, worker):
    watcher.child_exit(server, worker)
