# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
from time import sleep

from flask import Flask
from library.python.gunicorn import run_standalone


def main():
    """
    Это пример использования, в котором:
    - создается gunicorn-сервер с flask, умеющий считать количество запросов в работе
    - в нем создается solomon-сервер, который эту информацию отдает в виде метрик

    (см. gunicorn_conf.py)

    Получаем метрики соломона:
    curl localhost:9947/metrics/
    {"sensors":[{"kind":"GAUGE","labels":{"sensor":"requests_in_work_max"},"value":8},{"kind":"GAUGE","labels":{"sensor":"requests_in_work"},"value":0}]}

    Создаем запросы на наш сервер:
    while true; do curl localhost:8000; done

    Видим изменения в метрике requests_in_work
    curl localhost:9947/metrics/
    {"sensors":[{"kind":"GAUGE","labels":{"sensor":"requests_in_work_max"},"value":8},{"kind":"GAUGE","labels":{"sensor":"requests_in_work"},"value":1}]}
    """

    os.environ['GUNICORN_CMD_ARGS'] = '--config=travel/library/python/gunicorn/worker_watcher/example/gunicorn_conf.py'

    app = Flask("app")
    app.route('/')(lambda: sleep(0.2) or "Hello")
    run_standalone(app)


if __name__ == '__main__':
    main()
