# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from multiprocessing import Value


class WorkersWatcher(object):
    def __init__(self):
        self.req_counter = {}
        self._max_requests_in_work = None
        self.gunicorn_server = None

    def get_requests_in_work_count(self):
        return sum(c.value for c in self.req_counter.values())

    def get_max_requests_in_work(self):
        worker_class = self.gunicorn_server.cfg.worker_class
        if callable(getattr(worker_class, 'get_max_requests_in_process', None)):
            return worker_class.get_max_requests_in_process(self.gunicorn_server.cfg)
        return 0

    def on_starting(self, server):
        self.gunicorn_server = server

    def pre_fork(self, arbiter, worker):
        self.req_counter[id(worker)] = worker.counter = Value('i', 0)

    def child_exit(self, server, worker):
        self.req_counter.pop(id(worker))
