# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


class ObserveRequestsMixin(object):
    def handle_request(self, *args, **kwargs):
        self.on_handle_request_started(*args, **kwargs)
        try:
            return super(ObserveRequestsMixin, self).handle_request(*args, **kwargs)
        finally:
            self.on_handle_request_finished(*args, **kwargs)

    def on_handle_request_started(self, *args, **kwargs):
        pass

    def on_handle_request_finished(self, *args, **kwargs):
        pass


class RequestsCountMixin(ObserveRequestsMixin):
    def __init__(self, *args, **kwargs):
        super(RequestsCountMixin, self).__init__(*args, **kwargs)
        self.counter = None

    def on_handle_request_started(self, *args, **kwargs):
        self.change_counter(1)

    def on_handle_request_finished(self, *args, **kwargs):
        self.change_counter(-1)

    def change_counter(self, diff):
        with self.counter.get_lock():
            self.counter.value += diff

    def get_counter(self):
        with self.counter.get_lock():
            return self.counter.value
