# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from gunicorn.workers import gthread
from gunicorn.workers import sync

from travel.library.python.gunicorn.worker_watcher.worker_mixin import RequestsCountMixin


class ThreadWorker(RequestsCountMixin, gthread.ThreadWorker):
    def __init__(self, *args, **kwargs):
        super(ThreadWorker, self).__init__(*args, **kwargs)

    @staticmethod
    def get_max_requests_in_process(cfg):
        return cfg.workers * cfg.threads


class SyncWorker(RequestsCountMixin, sync.SyncWorker):
    def __init__(self, *args, **kwargs):
        super(SyncWorker, self).__init__(*args, **kwargs)

    @staticmethod
    def get_max_requests_in_process(cfg):
        return cfg.workers
