from aiohttp import web

from travel.library.python.probes.shutdown_switcher import ShutdownSwitcher


class SimpleProbesServer:
    def __init__(self, port):
        self._shutdown_switcher = ShutdownSwitcher()
        self._port = port

        self._app = self._build_app()

    def ping(self, request):
        ok = self._shutdown_switcher.ping()
        if ok:
            return web.Response(text='ok', status=200)
        else:
            return web.Response(text='error', status=410)

    def shutdown(self, request):
        self._shutdown_switcher.shutdown()
        return web.Response(text='ok', status=200)

    def run(self):
        web.run_app(self._app, port=self._port)

    def _build_app(self):
        routes = [
            web.get('/ping', self.ping),
            web.post('/shutdown', self.shutdown)
        ]

        app = web.Application()
        app.add_routes(routes)
        return app
