# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import requests


def get_environments_without_secret(project, secret, token=None):
    url = 'https://platform.yandex-team.ru/api/v1/project/{}'.format(project)

    session = requests.Session()
    session.headers.update({'Authorization': 'OAuth {}'.format(token)})

    projects = session.get(url).json()

    environment_ids = []
    for project_data in projects['applications']:
        for e in project_data['environments']:
            environment_ids.append(e['objectId'])

    environments_without_secret = []
    for e_id in environment_ids:
        url = 'https://platform.yandex-team.ru/api/v1/environment/dump/{}'.format(e_id)
        environ_data = session.get(url).json()

        if not _environment_has_secret(environ_data, secret):
            environments_without_secret.append(e_id)

    return environments_without_secret


def _environment_has_secret(environ_data, secret):
    for component_data in environ_data['components']:
        for secret_data in component_data['secrets']:
            if secret in secret_data['objectId']:
                return True
    return False
