#!/usr/bin/env bash

version=$(python -c 'import rasp_vault; print(rasp_vault.__VERSION__)')
rm debian/changelog; dch --create --newversion $version -D unstable --package yandex-rasp-vault 'New Release'

dpkg-buildpackage -b

deb_version=$(dpkg-parsechangelog --show-field Version)

if [ $deb_version != $version ]; then
    echo Bad deb version $deb_version
    exit 1;
fi

changelog=../yandex-rasp-vault_${deb_version}_all.changes
dpkg-genchanges -A > $changelog
debsign $changelog
dupload --nomail --to yandex-rasp-$(lsb_release -sc) $changelog
