# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import gzip
import os

try:
    from StringIO import StringIO  # for Python 2
except ImportError:
    from io import StringIO  # for Python 3

from library.python import resource

RES_FS_PREFIX = 'resfs/file/'


def extract_resources(prefix, base_path=None, strip_prefix=True):
    """Копируем файлы из бинарника и раскладываем их на файловой системе."""
    for path, data in resource.iteritems(prefix='{}{}'.format(RES_FS_PREFIX, prefix), strip_prefix=strip_prefix):
        if not strip_prefix:
            path = path.replace(RES_FS_PREFIX, '')

        if base_path:
            path = os.path.join(base_path, path)

        if not os.path.exists(path):
            parent = os.path.normpath(os.path.join(path, os.pardir))
            if not os.path.exists(parent):
                os.makedirs(parent)
            with open(path, 'wb') as f:
                f.write(data)


def get_fileobj(file_path):
    file_data = resource.find(file_path)
    if file_data is None:
        raise Exception('File not found: {}'.format(file_path))

    return StringIO(file_data)


def unzip(file_path, **gzip_kwargs):
    """
    with unzip('my/file.gz') as f:
        f.read()
    """
    fileobj = get_fileobj(file_path)
    return gzip.GzipFile(fileobj=fileobj, **gzip_kwargs)
