import logging

import boto3


class S3Client:

    def __init__(self, endpoint: str, bucket: str, access_key: str, access_secret_key: str):
        self.bucket = bucket

        session = boto3.session.Session(
            aws_access_key_id=access_key,
            aws_secret_access_key=access_secret_key,
        )
        self.client = session.client(service_name='s3', endpoint_url=endpoint, verify=False)

    def get_reader(self, key: str):
        return self.client.get_object(Bucket=self.bucket, Key=key)['Body']

    def read(self, key: str) -> bytes:
        return self.get_reader(key).read()

    def write(self, key: str, data: str) -> None:

        logging.info(f'Uploading data to {key}')
        self.client.put_object(
            Bucket=self.bucket,
            Key=key,
            Body=data,
        )
        logging.info('Upload finished')
