# -*- coding: utf-8 -*-

"""
Функции для безопасного парсинга xml
https://wiki.yandex-team.ru/security/for/developers#xxe
"""


from lxml import etree, html


XML_PARSER_SAFE_ARGS = {'resolve_entities': False, 'load_dtd': False, 'no_network': True}
HTML_PARSER_SAFE_ARGS = {'no_network': True}


def get_html_safe_parser(**kwargs):
    params = {'remove_blank_text': True}

    params.update(kwargs)
    params.update(HTML_PARSER_SAFE_ARGS)

    return html.HTMLParser(**params)


def get_xml_safe_parser(**kwargs):
    params = {'remove_blank_text': True}

    params.update(kwargs)
    params.update(XML_PARSER_SAFE_ARGS)

    return etree.XMLParser(**params)


def safe_parse_xml(filepath, **kwargs):
    return etree.parse(filepath, parser=get_xml_safe_parser(**kwargs))


def safe_xml_fromstring(text, **kwargs):
    return etree.fromstring(text, parser=get_xml_safe_parser(**kwargs))
