# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import time

from library.python.monlib.metric_registry import HistogramType


class Metric(object):
    def __init__(self, sensor, labels, value):
        self.labels = labels.copy() if labels is not None else {}
        self.value = value
        self.created_at = int(time.time())

        self.labels.update({
            'sensor': sensor,
        })


class GaugeMetric(Metric):
    pass


class RateMetric(Metric):
    def __init__(self, sensor, labels, value=1):
        super(RateMetric, self).__init__(sensor, labels, value)


class HistogramRateMetric(Metric):
    def __init__(self, histogram_type, histogram_options, sensor, labels, value):
        super(HistogramRateMetric, self).__init__(sensor, labels, value)
        self.histogram_type = histogram_type
        self.histogram_options = histogram_options


class ExplicitHistogramRateMetric(HistogramRateMetric):
    DEFAULT_BUCKETS = sorted(set([int(pow(1.3, x)) for x in range(0, 48)]))

    def __init__(self, sensor, labels, value, buckets=None):
        super(ExplicitHistogramRateMetric, self).__init__(
            HistogramType.Explicit,
            {
                'buckets': buckets or self.DEFAULT_BUCKETS,
            },
            sensor,
            labels,
            value,
        )
