# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

_context = {}


def set_context(ctx):
    """
    Sets (or replaces) current global tracing context.

    :param ctx: arbitrary dict, containing necessary global context.
    :return:
    """
    global _context
    _context = ctx


def add_context_to_span(span):
    """
    Adds current global context to provided span
    :param span: some opentracing Span
    :return:
    """
    for key, value in _context.items():
        span.set_tag(key, value)


def set_qloud_image_version():
    """
    Helper function, which adds information about current application version to global context.
    :return:
    """
    if 'QLOUD_DOCKER_IMAGE' in os.environ:
        global _context
        docker_image_name = os.getenv('QLOUD_DOCKER_IMAGE')
        application_version = docker_image_name.split(':')[-1]
        _context['application-version'] = application_version
