import os
import threading
import tornado

from opentracing_instrumentation.client_hooks import install_all_patches
from opentracing_instrumentation.client_hooks.requests import patcher

from travel.library.python.tracing.tracing.tracing import Tracing


def add_version_hook(image_version):
    def hook(response, span):
        span.set_tag('image-version', image_version)
    return hook


def build_post_fork(jaeger_config, func=None):
    is_tracing_on = os.environ.get('TRACING_IS_TRACING_ON', False)
    if not is_tracing_on:
        return lambda server, worker: None

    def post_fork(server, worker):
        from travel.library.python.tracing import tracing

        tracer = jaeger_config.initialize_tracer()
        tracing.tracing = Tracing(tracer)

        docker_image_name = os.getenv('QLOUD_DOCKER_IMAGE', False)
        if docker_image_name:
            tracing.image_version = docker_image_name.split(':')[-1]
            patcher.set_response_handler_hook(add_version_hook(tracing.image_version))

        install_all_patches()

        thread = threading.Thread(target=lambda: tornado.ioloop.IOLoop.current().start())
        thread.setDaemon(True)
        thread.start()

        if func is not None:
            func()

    return post_fork
