from opentracing import global_tracer
from travel.library.python.tracing.tracing.tracing import _tracing


class TracingMiddleware:
    def process_view(self, request, view_func, view_args, view_kwargs):
        tracer = global_tracer()
        active_span = getattr(tracer.scope_manager.active, 'span', None)
        if active_span is not None:
            active_span.set_tag('reqid', request.GET.get('reqid'))
            if _tracing.image_version is not None:
                active_span.set_tag('image-version', _tracing.image_version)

            with tracer.scope_manager.activate(active_span, True) as scope:
                return view_func(request, *view_args, **view_kwargs)
