# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from typing import Optional  # noqa


class ServiceTicket(object):
    def __init__(self, src, dst=None, scopes=None, debug_string=None, logging_string=None):
        # type: (int, Optional[int], Optional[str], Optional[str], Optional[str]) -> None
        self.src = src
        self.dst = dst
        self.scopes = scopes
        self.debug_string = debug_string
        self.logging_string = logging_string

    def __str__(self):
        return 'ServiceTicket: from {src} to {dst}, scopes={scopes}'.format(
            src=self.src,
            dst=self.dst,
            scopes=self.scopes,
        )

    def __repr__(self):
        return self.__str__()


class UserTicket(object):
    def __init__(self, uids=None, default_uid=None, scopes=None, debug_string=None, logging_string=None):
        # type: (Optional[list], Optional[int], Optional[list], Optional[str], Optional[str]) -> None
        self.uids = uids or []
        self.default_uid = default_uid
        self.scopes = scopes or []
        self.debug_string = debug_string
        self.logging_string = logging_string

    def check_uid(self, uid):
        # type: (int) -> bool
        return int(uid) in self.uids

    def __str__(self):
        return 'UserTicket: default_uid={default_uid}, scopes={scopes}'.format(
            default_uid=self.default_uid,
            scopes=self.scopes,
        )

    def __repr__(self):
        return self.__str__()
