# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from travel.library.recipe_utils.utils import log
from travel.library.recipe_utils.mysql_schema import load_schema


class MysqlSchemaLoader(object):
    def __init__(self):
        self.dump_archive_path = None
        self.dump_path = None
        self.db = None
        self.host = None
        self.port = None
        self.user = None
        self.password = None
        self.mysql_executable = None

    def setup(self):
        self.dump_archive_path = os.getenv('TRAVEL_RECIPE_MYSQL_DUMP_PATH', 'travel/recipes/schema_dump.gz')
        self.host = os.getenv('TRAVEL_MYSQL_RECIPE_HOST', '127.0.0.1')
        self.port = int(os.getenv('TRAVEL_MYSQL_RECIPE_PORT', 3306))
        self.user = os.getenv('TRAVEL_MYSQL_RECIPE_USER', 'root')
        self.password = os.getenv('TRAVEL_MYSQL_RECIPE_PASSWORD', '')
        self.db = os.getenv('TRAVEL_MYSQL_RECIPE_TESTS_DB', 'test_avia')

        mysql_dir = os.getenv('TRAVEL_MYSQL_DIR')
        if mysql_dir:
            self.mysql_executable = os.path.join(mysql_dir, 'bin', 'mysql')

        log('MysqlSchemaLoader', self.dump_archive_path, self.db, self.host, self.port, self.user, self.mysql_executable)

        self.dump_path = load_schema(
            dump_archive_path=self.dump_archive_path,
            db=self.db,
            user=self.user,
            passwd=self.password,
            host=self.host,
            port=self.port,
            mysql_executable=self.mysql_executable,
        )

    def teardown(self):
        log('Nothing to teardown with db schema ... ')

    @property
    def description(self):
        return 'mysql-schema-step: {} -> {}'.format(self.dump_archive_path, self.db)
