# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
import traceback

from library.python.testing.recipe import declare_recipe
from travel.library.recipes.library import mysql, mysql_schema
from travel.library.recipe_utils.utils import log


def get_steps():
    steps = []

    if not os.getenv('TRAVEL_COMMON_RECIPE_SKIP_DB_START'):
        steps.extend([mysql])

    steps.append(mysql_schema.MysqlSchemaLoader())

    return steps


def start(argv):
    for step in get_steps():
        log('Setting up {}'.format(step.description))
        try:
            step.setup()
        except Exception as ex:
            log('Exception', repr(ex), traceback.format_exc())
            raise ex
    log('Done.')


def stop(argv):
    for step in get_steps():
        try:
            log('Tearing down {}'.format(step.description))
            step.teardown()
        except Exception as ex:
            log('Failed tearing down step {} because of {}'.format(step.description, ex))


def main():
    declare_recipe(start, stop)
