import logging

from django_pgaas import HostManager
from travel.library.python.avia_mdb_replica_info.avia_mdb_replica_info import MdbAPI, POSTGRES_API_BASE_URL

log = logging.getLogger(__name__)


class MdbHostManager(object):
    def __init__(self, oauth_token, current_dc=None):
        self.mdb_api = MdbAPI(
            api_base_url=POSTGRES_API_BASE_URL,
            oauth_token=oauth_token,
        )
        self.current_dc = current_dc

    def get_host_string(self, cluster_id, fallback_hosts):
        try:
            cluster_info = self.mdb_api.get_cluster_info(cluster_id=cluster_id)
            instances = [(i.hostname, i.dc) for i in cluster_info.instances]
        except Exception as ex:
            log.warn("Failed to get hosts from mdb {}".format(ex))
            instances = [(h, h.split("-")[0]) for h in fallback_hosts.split(",")]

        return HostManager(instances, self.current_dc).host_string
