from django.conf import settings
from django.core.files.storage import get_storage_class
from storages.backends.s3boto3 import S3Boto3Storage


class MdsS3Storage(S3Boto3Storage):
    bucket_name = settings.MDS_MARKETING_CONTENT_BUCKET
    access_key = settings.MDS_ACCESS_KEY_ID
    secret_key = settings.MDS_ACCESS_SECRET_KEY
    endpoint_url = settings.MDS_URL
    location = settings.MDS_MEDIA_LOCATION
    auto_create_bucket = False


if not settings.MDS_URL:
    # для тестов и дева
    mds_s3_media_storage = get_storage_class()()
else:
    mds_s3_media_storage = MdsS3Storage()
