import logging

from datetime import datetime
from dateutil.tz import tzlocal
from django.http import HttpResponse
from http.cookies import SimpleCookie


class PingResponder(object):
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        if request.path in ["/ping", "/ping/"]:
            return HttpResponse("pong!", content_type="text/plain")

        return self.get_response(request)


class AccessLogMiddleware(object):
    def __init__(self, get_response):
        self.get_response = get_response
        self.log = logging.getLogger('yt.travel-content-admin-access-logger')

    def __call__(self, request):
        response = self.get_response(request)

        yandex_login, yandexuid = None, None
        if 'COOKIE' in request.headers:
            cookie = SimpleCookie()
            cookie.load(request.headers['COOKIE'])
            if 'yandex_login' in cookie:
                yandex_login = cookie['yandex_login'].value
            if 'yandexuid' in cookie:
                yandexuid = cookie['yandexuid'].value

        env = request.environ
        msg = {
            'time': datetime.now(tz=tzlocal()).strftime('%d/%b/%Y:%H:%M:%S %z'),
            'user': request.user.username,
            'yandex_login': yandex_login,
            'yandexuid': yandexuid,
            'http_user_agent': env.get('HTTP_USER_AGENT'),
            'http_referrer': env.get('HTTP_REFERER'),
            'src_ip': env.get('HTTP_X_FORWARDED_FOR'),
            'request': '{} {} {}'.format(env.get('REQUEST_METHOD'), env.get('RAW_URI'), env.get('SERVER_PROTOCOL')),
            'status': response.status_code
        }

        self.log.info(msg)

        return response
