import os
import sys

from library.python.gunicorn import run_standalone
from travel.marketing.content.admin import wsgi


def manage():
    print('Loading manage.py')
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "local_settings")
    from django.core.management import execute_from_command_line
    execute_from_command_line(sys.argv)


def gunicorn():
    run_standalone(wsgi.application)


def update_dicts():
    from travel.marketing.content.admin.scripts.update_dicts import run_cli
    run_cli()


if __name__ == '__main__':
    func_name = os.getenv('PYTHON_ENTRYPOINT_RUN_FUNC')
    print('run_func', func_name)
    globals()[func_name]()
