from travel.marketing.content.admin.settings import *  # noqa

STATIC_ROOT = '/app/static'

LOG_PATH = '/var/log/app'

BASE_LOG_LEVEL = os.environ.get('RASP_BASE_LOG_LEVEL', 'INFO')
_format = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'simple': {'format': _format},
        'exception': {
            '()': 'ylog.ExceptionFormatter',
            'format': _format,
            'full': True,
            'show_locals': True
        },
        'json_formatter': {
            'class': 'pythonjsonlogger.jsonlogger.JsonFormatter',
            'json_ensure_ascii': False
        }
    },
    'handlers': {
        'application': {
            'class': 'logging.FileHandler',
            'filename': os.path.join(LOG_PATH, 'application.log'),
            'formatter': 'simple',
        },
        'warnings': {
            'class': 'logging.FileHandler',
            'filename': os.path.join(LOG_PATH, 'warnings.log'),
            'formatter': 'simple',
        },
        'exception': {
            'class': 'logging.FileHandler',
            'filename': os.path.join(LOG_PATH, 'exception.log'),
            'formatter': 'exception',
            'level': 'ERROR',
        },
        'stdout_application': {
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stdout',
            'formatter': 'simple'
        },
        'stdout_warnings': {
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stdout',
            'formatter': 'simple',
        },
        'stderr': {
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stderr',
            'formatter': 'simple',
            'level': 'ERROR',
        },
        'yt.travel-content-admin-access-log': {
            'class': 'logging.handlers.WatchedFileHandler',
            'level': 'INFO',
            'filename': os.path.join(LOG_PATH, 'yt', 'travel-content-admin-access.log'),
            'formatter': 'json_formatter'
        },
    },
    'loggers': {
        '': {
            'handlers': ['application', 'stdout_application'],
            'level': BASE_LOG_LEVEL,
        },
        'py.warnings': {
            'propagate': False,
            'handlers': ['warnings', 'stdout_warnings'],
            'level': BASE_LOG_LEVEL,
        },
        'django': {
            'handlers': ['exception', 'stderr'],
            'level': 'ERROR',
        },
        'yt.travel-content-admin-access-logger': {
            'handlers': ['yt.travel-content-admin-access-log'],
            'level': 'INFO'
        }
    }
}
