import os

import yenv
from django_yauth.settings import *  # noqa
from django_idm_api.settings import IDM_API_TVM_DEFAULTS

from travel.library.python.rasp_vault.api import get_secret
from travel.marketing.content.admin.admin.connection import MdbHostManager

WSGI_APPLICATION = "travel.marketing.content.admin.wsgi.application"

PROJECT_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), "../.."))

SECRET_KEY = get_secret("marketing-content-testing.DJANGO_SECRET_KEY", "secret")

DEBUG = False

ALLOWED_HOSTS = ["*"]

ROOT_URLCONF = "travel.marketing.content.admin.urls"

INSTALLED_APPS = [
    "travel.marketing.content.admin.admin.apps.ContentAdminConfig",
    "travel.marketing.content.admin.www",
    "django_pgaas",
    "django_yauth",
    "storages",

    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
]

MIDDLEWARE = [
    "travel.marketing.content.admin.admin.middleware.PingResponder",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "travel.marketing.content.admin.admin.middleware.AccessLogMiddleware",
    "django.middleware.security.SecurityMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

STATICFILES_FINDERS = [
    "django.contrib.staticfiles.finders.FileSystemFinder",
    "django.contrib.staticfiles.finders.AppDirectoriesFinder",
    "library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder"
]

TEMPLATES = [
    {
        "BACKEND": "library.python.django.template.backends.arcadia.ArcadiaTemplates",
        "OPTIONS": {
            "debug": False,
            "loaders": [
                "library.python.django.template.loaders.resource.Loader",
                "library.python.django.template.loaders.app_resource.Loader",
            ],
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    }
]

FORM_RENDERER = "library.python.django.template.backends.forms_renderer.ArcadiaRenderer"

MDB_OAUTH_TOKEN = get_secret('rasp-common.MDB_OAUTH_TOKEN')
host_manager = MdbHostManager(MDB_OAUTH_TOKEN)

MDS_ACCESS_KEY_ID = get_secret('rasp-common.MDS_ACCESS_KEY_ID')
MDS_ACCESS_SECRET_KEY = get_secret('rasp-common.MDS_ACCESS_SECRET_KEY')
MDS_URL = 'http://s3.mds.yandex.net'
MDS_MEDIA_LOCATION = 'media/'

IDM_TVM_CLIENT_ID = 2001600
IDM_API_TVM_DEFAULTS['allowed_clients'] = (IDM_TVM_CLIENT_ID,)
IDM_INSTANCE = 'production'
IDM_URL_PREFIX = 'idm/'

YAUTH_TYPE = 'intranet'
YAUTH_USE_NATIVE_USER = True
YAUTH_USE_SITES = False
YAUTH_CREATE_USER_ON_ACCESS = True  # чтобы не было 500ки при попытке входа у пользователей без доступа к админке

AVATAR_NAMESPACE = 'rasp'

if yenv.type == 'testing':
    AVATAR_READ_URL = 'https://avatars.mdst.yandex.net'
    AVATAR_WRITE_URL = 'http://avatars-int.mdst.yandex.net:13000'

    SECRET_KEY = get_secret("marketing-content-testing.DJANGO_SECRET_KEY", "secret")
    PGAAS_CLUSTER_ID = get_secret("marketing-content-testing.PGAAS_CLUSTER_ID")
    PGAAS_FALLBACK_HOSTS = get_secret("marketing-content-testing.PGAAS_FALLBACK_HOSTS")

    MDS_MARKETING_CONTENT_BUCKET = 'travel-marketing-content-test-bucket'

    IDM_API_TVM_SETTINGS = {
        'client_id': get_secret('marketing-content-testing.TVM_CLIENT_ID'),
        'secret': get_secret('marketing-content-testing.TVM_CLIENT_SECRET'),
    }

    MIDDLEWARE.remove('django.contrib.auth.middleware.AuthenticationMiddleware')
    MIDDLEWARE += ['django_idm_api.middleware.TVMMiddleware', 'django_yauth.middleware.YandexAuthMiddleware']
    INSTALLED_APPS = ['django_idm_api'] + INSTALLED_APPS

    DATABASES = {
        "default": {
            "ENGINE": "django_pgaas.backend",
            "NAME": "content",
            "USER": get_secret("marketing-content-testing.PGAAS_USER"),
            "PASSWORD": get_secret("marketing-content-testing.PGAAS_PASSWORD"),
            "HOST": host_manager.get_host_string(PGAAS_CLUSTER_ID, PGAAS_FALLBACK_HOSTS),
            "PORT": 6432,
            'DISABLE_SERVER_SIDE_CURSORS': True,
            "OPTIONS": {
                "target_session_attrs": "read-write",
                "connect_timeout": 10,
            },
        },
    }
elif yenv.type == 'production':
    AVATAR_READ_URL = 'https://avatars.mds.yandex.net'
    AVATAR_WRITE_URL = 'http://avatars-int.mds.yandex.net:13000'

    SECRET_KEY = get_secret("marketing-content-production.DJANGO_SECRET_KEY", "secret")
    PGAAS_CLUSTER_ID = get_secret("marketing-content-production.PGAAS_CLUSTER_ID")
    PGAAS_FALLBACK_HOSTS = get_secret("marketing-content-production.PGAAS_FALLBACK_HOSTS")
    MDS_MARKETING_CONTENT_BUCKET = 'travel-marketing-content-bucket'

    IDM_API_TVM_SETTINGS = {
        'client_id': get_secret('marketing-content-production.TVM_CLIENT_ID'),
        'secret': get_secret('marketing-content-production.TVM_CLIENT_SECRET'),
    }

    MIDDLEWARE.remove('django.contrib.auth.middleware.AuthenticationMiddleware')
    MIDDLEWARE += ['django_idm_api.middleware.TVMMiddleware', 'django_yauth.middleware.YandexAuthMiddleware']
    INSTALLED_APPS = ['django_idm_api'] + INSTALLED_APPS

    DATABASES = {
        "default": {
            "ENGINE": "django_pgaas.backend",
            "NAME": "content",
            "USER": get_secret("marketing-content-production.PGAAS_USER"),
            "PASSWORD": get_secret("marketing-content-production.PGAAS_PASSWORD"),
            "HOST": host_manager.get_host_string(PGAAS_CLUSTER_ID, PGAAS_FALLBACK_HOSTS),
            "PORT": 6432,
            'DISABLE_SERVER_SIDE_CURSORS': True,
            "OPTIONS": {
                "target_session_attrs": "read-write",
                "connect_timeout": 10,
            },
        },
    }
else:
    SECRET_KEY = "secret"
    MDS_URL = None
    MDS_MARKETING_CONTENT_BUCKET = None

    DATABASES = {
        "default": {
            "ENGINE": "django_pgaas.backend",
            "NAME": "content",
            "USER": "admin",
            "PASSWORD": "12345",
            "HOST": "localhost",
            "PORT": 5432
        },
    }

# Отключает ошибку при запуске миграции из-за отсутсвия "django.contrib.auth.middleware.AuthenticationMiddleware"
SILENCED_SYSTEM_CHECKS = ['admin.E408']

# Internationalization
ADMIN_LANGUAGES = ["ru", "en"]
MODEL_LANGUAGES = ["ru", "en", "tr", "uk"]
LANGUAGE_CODE = "ru"
BASE_LANGUAGE = "ru"
TIME_ZONE = "UTC"
USE_I18N = True
USE_L10N = True
USE_TZ = True


STATIC_URL = "/static/"
STATIC_ROOT = os.path.join(PROJECT_PATH, "static/")
